/*
MySQL Data Transfer
Source Host: localhost
Source Database: survey
Target Host: localhost
Target Database: survey
Date: 6-3-2007 2:31:14
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for answers
-- ----------------------------
CREATE TABLE `answers` (
  `answer_id` int(11) NOT NULL auto_increment,
  `question_id` int(11) default NULL,
  `answer_text` longtext collate latin1_general_ci,
  PRIMARY KEY  (`answer_id`),
  KEY `survey_id` (`answer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- ----------------------------
-- Table structure for question_types
-- ----------------------------
CREATE TABLE `question_types` (
  `type_id` int(11) NOT NULL,
  `type_name` varchar(50) collate latin1_general_ci default NULL,
  PRIMARY KEY  (`type_id`),
  KEY `type_id` (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- ----------------------------
-- Table structure for questions
-- ----------------------------
CREATE TABLE `questions` (
  `question_id` int(11) NOT NULL auto_increment,
  `survey_id` int(11) default NULL,
  `question_text` longtext collate latin1_general_ci,
  `question_type` tinyint(4) default NULL,
  `sort_order` int(11) default NULL,
  PRIMARY KEY  (`question_id`),
  KEY `survey_id` (`question_id`),
  KEY `survey_id1` (`survey_id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- ----------------------------
-- Table structure for respondents
-- ----------------------------
CREATE TABLE `respondents` (
  `respondent_id` int(11) NOT NULL auto_increment,
  `survey_id` int(11) default NULL,
  `date_response_start` datetime default NULL,
  `date_response_end` datetime default NULL,
  `respondent_ip` varchar(24) collate latin1_general_ci default NULL,
  PRIMARY KEY  (`respondent_id`),
  KEY `responder_id` (`respondent_id`),
  KEY `responder_ip` (`respondent_ip`),
  KEY `survey_id` (`survey_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- ----------------------------
-- Table structure for responses
-- ----------------------------
CREATE TABLE `responses` (
  `response_id` int(11) NOT NULL auto_increment,
  `respondent_id` int(11) default NULL,
  `question_id` int(11) default NULL,
  `answer_id` int(11) default NULL,
  `yes_no_response` tinyint(4) default NULL,
  `text_response` longtext collate latin1_general_ci,
  `multi_response` varchar(255) collate latin1_general_ci default NULL,
  PRIMARY KEY  (`response_id`),
  KEY `answer_id` (`answer_id`),
  KEY `question_id` (`question_id`),
  KEY `respondent_id` (`respondent_id`),
  KEY `response_id` (`response_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- ----------------------------
-- Table structure for statuses
-- ----------------------------
CREATE TABLE `statuses` (
  `status_code` varchar(50) collate latin1_general_ci NOT NULL,
  `status_text` longtext collate latin1_general_ci,
  PRIMARY KEY  (`status_code`),
  KEY `status_id` (`status_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- ----------------------------
-- Table structure for surveys
-- ----------------------------
CREATE TABLE `surveys` (
  `survey_id` int(11) NOT NULL auto_increment,
  `survey_name` varchar(100) collate latin1_general_ci default NULL,
  `survey_desc` longtext collate latin1_general_ci,
  `date_added` datetime default NULL,
  `date_start` datetime default NULL,
  `date_end` datetime default NULL,
  `is_acive` tinyint(4) default NULL,
  PRIMARY KEY  (`survey_id`),
  KEY `event_id` (`survey_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `answers` VALUES ('1', '1', 'Excellent');
INSERT INTO `answers` VALUES ('2', '1', 'Very Good');
INSERT INTO `answers` VALUES ('3', '1', 'Good');
INSERT INTO `answers` VALUES ('4', '1', 'Poor');
INSERT INTO `answers` VALUES ('5', '1', 'No opinion');
INSERT INTO `answers` VALUES ('6', '2', 'Very satisifed');
INSERT INTO `answers` VALUES ('7', '2', 'Somewhat satisifed');
INSERT INTO `answers` VALUES ('8', '2', 'Not satisifed');
INSERT INTO `answers` VALUES ('9', '2', 'No opinion');
INSERT INTO `answers` VALUES ('10', '3', 'Very satisifed');
INSERT INTO `answers` VALUES ('11', '3', 'Somewhat satisifed');
INSERT INTO `answers` VALUES ('12', '3', 'Not satisifed');
INSERT INTO `answers` VALUES ('13', '3', 'No opinion');
INSERT INTO `answers` VALUES ('14', '4', 'Answer 1');
INSERT INTO `answers` VALUES ('15', '4', 'Answer 2');
INSERT INTO `answers` VALUES ('16', '4', 'Answer 3');
INSERT INTO `answers` VALUES ('17', '4', 'Answer 4');
INSERT INTO `answers` VALUES ('21', '7', 'Very likely');
INSERT INTO `answers` VALUES ('22', '7', 'Somewhat likely');
INSERT INTO `answers` VALUES ('23', '7', 'Not likely');
INSERT INTO `answers` VALUES ('24', '7', 'No opinion');
INSERT INTO `answers` VALUES ('25', '12', 'ASP');
INSERT INTO `answers` VALUES ('26', '12', 'PHP');
INSERT INTO `answers` VALUES ('27', '12', 'ASP.NET (VB)');
INSERT INTO `answers` VALUES ('28', '12', 'ASP.NET (C#)');
INSERT INTO `answers` VALUES ('29', '13', 'Answer 1');
INSERT INTO `answers` VALUES ('30', '13', 'Answer 2');
INSERT INTO `answers` VALUES ('31', '13', 'Answer 3');
INSERT INTO `answers` VALUES ('32', '14', 'Selection 1');
INSERT INTO `answers` VALUES ('33', '14', 'Selection 2');
INSERT INTO `answers` VALUES ('34', '14', 'Selection 3');
INSERT INTO `answers` VALUES ('35', '14', 'Selection 4');
INSERT INTO `answers` VALUES ('36', '13', 'Answer 4');
INSERT INTO `answers` VALUES ('37', '13', 'Answer 5');
INSERT INTO `answers` VALUES ('38', '14', 'Selection 5');
INSERT INTO `answers` VALUES ('39', '14', 'Selection 6');
INSERT INTO `question_types` VALUES ('1', 'Single choice');
INSERT INTO `question_types` VALUES ('2', 'Yes/No');
INSERT INTO `question_types` VALUES ('3', 'Written response');
INSERT INTO `question_types` VALUES ('4', 'Multiple choice (checkbox)');
INSERT INTO `question_types` VALUES ('5', 'Multiple choice (listbox)');
INSERT INTO `questions` VALUES ('1', '1', 'What is your overall impression of Codecharge Studio?', '1', '10');
INSERT INTO `questions` VALUES ('2', '1', 'How satisfied are you with CCS functionality?', '1', '30');
INSERT INTO `questions` VALUES ('3', '1', 'How satisfied are you with CCS ease-of-use?', '1', '20');
INSERT INTO `questions` VALUES ('4', '3', 'This is sample question for sample survey, single-choice selection', '1', '10');
INSERT INTO `questions` VALUES ('5', '3', 'This is sample question for sample survey, text entry', '3', '20');
INSERT INTO `questions` VALUES ('7', '1', 'How likely are you to recommend CCS to someone else?', '1', '40');
INSERT INTO `questions` VALUES ('8', '1', 'What features would further simplify your application development process?', '3', '50');
INSERT INTO `questions` VALUES ('9', '1', 'Did you find this survey useful?', '2', '70');
INSERT INTO `questions` VALUES ('10', '3', 'This is sample question for sample survey, Yes/No selection', '2', '30');
INSERT INTO `questions` VALUES ('11', '2', 'An invalid question because this survey is inactive.', '3', '10');
INSERT INTO `questions` VALUES ('12', '1', 'Which programming language(s) are you using?', '4', '60');
INSERT INTO `questions` VALUES ('13', '3', 'This is sample question for sample survey, Multi-selection via checkbox', '4', '40');
INSERT INTO `questions` VALUES ('14', '3', 'This is sample question for sample survey, Multi-selection via listbox', '5', '50');
INSERT INTO `statuses` VALUES ('completed', '<p align=\"center\"><strong><font face=\"Arial\" color=\"#bb0000\" size=\"4\">You already&nbsp;participated in this survey. Thank you.</font></strong></p>');
INSERT INTO `statuses` VALUES ('invalid', '<p align=\"center\"><strong><font face=\"Arial\" color=\"#bb0000\" size=\"4\">Sorry, this is an invalid survey.</font></strong></p>');
INSERT INTO `statuses` VALUES ('thanks', '<p align=\"center\"><strong><font face=\"Arial\" color=\"#000080\" size=\"4\">Thank You for responding to our Survey.</font></strong></p>\r\n<p align=\"center\"><strong><font face=\"Arial\" color=\"#000080\" size=\"4\">Your response is greatly appreciated.</font></strong></p>');
INSERT INTO `surveys` VALUES ('1', 'CodeCharge/Studio Evaluation', 'After-evaluation Survey', null, null, null, '1');
INSERT INTO `surveys` VALUES ('2', 'This survey is inactive. If you see it fix the bug.', null, null, null, null, '0');
INSERT INTO `surveys` VALUES ('3', 'Sample Survey', null, null, null, null, '1');
